/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.VWScenarioFieldAssignments;
import filenet.sim.api.VWScenarioInputField;
import filenet.sim.api.VWScenarioOutputField;
import filenet.sim.api.VWScenarioOutputFields;
import filenet.sim.api.VWScenarioXMLHandler;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.base.VWString;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class VWScenarioFieldAssignmentsEntry
implements Serializable,
Comparable {
    private VWScenarioFieldAssignments m_parent = null;
    private Map m_inputValues = Collections.synchronizedMap(new HashMap());
    private VWScenarioOutputFields m_outputs = new VWScenarioOutputFields();

    protected VWScenarioFieldAssignmentsEntry(VWScenarioFieldAssignments parent) {
        this.m_parent = parent;
    }

    public void setInputValue(String fieldName, Object value) throws VWException {
        this.setInputValue(fieldName, value, true);
    }

    protected void setInputValue(String fieldName, Object value, boolean validate) throws VWException {
        if (validate) {
            VWScenarioInputField inputField = this.m_parent.getInputFields().getInputField(fieldName);
            if (inputField == null) {
                throw new VWException("sim.api.VWScenarioFieldAssignmentsEntry.InputFieldNotFound", "Input field not found: {0}.", fieldName);
            }
            this.validateInputValue(value, inputField.getFieldDefinition());
        }
        this.m_inputValues.put(fieldName, value);
    }

    public Object getInputValue(String fieldName) throws VWException {
        if (!this.m_parent.getInputFields().hasInputField(fieldName)) {
            throw new VWException("sim.api.VWScenarioFieldAssignmentsEntry.InvalidInputFieldName", "Invalid input field name: {0}.", fieldName);
        }
        return this.m_inputValues.get(fieldName);
    }

    protected Object getInputValueNoValidate(String fieldName) {
        return this.m_inputValues.get(fieldName);
    }

    public VWScenarioOutputFields getOutputs() {
        return this.m_outputs;
    }

    public int compareTo(Object o) {
        VWScenarioFieldAssignmentsEntry entry = (VWScenarioFieldAssignmentsEntry)o;
        int cmp = this.compareInputValues(entry);
        if (cmp != 0) {
            return cmp;
        }
        return this.m_outputs.compareTo(this.getOutputs());
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    protected int compareInputValues(VWScenarioFieldAssignmentsEntry entry) {
        Iterator i = this.m_parent.getInputFields().iterator();
        while (i.hasNext()) {
            int cmp;
            String fieldName = i.next().toString();
            Object thisValue = this.getInputValueNoValidate(fieldName);
            Object entryValue = entry.getInputValueNoValidate(fieldName);
            if (thisValue != null && entryValue != null) {
                cmp = thisValue instanceof Comparable ? ((Comparable)thisValue).compareTo(entryValue) : thisValue.toString().compareTo(entryValue.toString());
            } else if (thisValue == null && entryValue == null) {
                cmp = 0;
            } else {
                int n = cmp = thisValue == null ? -1 : 1;
            }
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    protected void setParent(VWScenarioFieldAssignments parent) {
        this.m_parent = parent;
    }

    protected void toXML(StringBuffer buffer, String baseIndent) throws VWException {
        String LEVEL_1_INDENT = baseIndent + "\t";
        buffer.append(baseIndent + "<FieldWeights>\n");
        Iterator i = this.m_parent.getInputFields().iterator();
        while (i.hasNext()) {
            String fieldName = i.next().toString();
            buffer.append(LEVEL_1_INDENT + "<InputValue ");
            buffer.append("Name=\"" + VWScenarioXMLHandler.toXMLString(fieldName) + "\" ");
            buffer.append("Value=\"" + VWScenarioXMLHandler.toXMLString(this.m_inputValues.get(fieldName)) + "\"/>\n");
        }
        i = this.getOutputs().iterator();
        while (i.hasNext()) {
            ((VWScenarioOutputField)i.next()).toXML(buffer, LEVEL_1_INDENT);
        }
        buffer.append(baseIndent + "</FieldWeights>\n");
    }

    private void validateInputValue(Object inputValue, VWFieldDefinition fieldDef) throws VWException {
        int expectedType = fieldDef.getFieldType();
        int foundType = VWFieldType.getVWFieldType(inputValue);
        boolean expectedIsArray = fieldDef.isArray();
        boolean foundIsArray = inputValue instanceof Object[];
        if (expectedType != foundType || expectedIsArray != foundIsArray) {
            throw new VWException("sim.api.VWScenarioFieldAssignments.InvalidValueForInputField", "Invalid value for input field, Expected type: {0}, Type found: {1}.", VWFieldType.getLocalizedString(expectedType) + (expectedIsArray ? "[ ]" : ""), VWFieldType.isValid(foundType) ? VWFieldType.getLocalizedString(foundType) : (inputValue != null ? inputValue.getClass().getName() : inputValue) + (foundIsArray ? "[ ]" : ""));
        }
    }

    protected void validate(int index) throws VWException {
        for (VWScenarioInputField inputField : this.m_parent.getInputFields()) {
            Object inputValue = this.getInputValueNoValidate(inputField.getFieldName());
            if (inputValue == null) {
                VWString theMessage = new VWString("sim.api.VWScenarioFieldAssignments.InputValueNotSpecified", "Field Assignments Row: {0}, Input value not specified for field {1}.", String.valueOf(index), inputField.getFieldName());
                this.m_parent.addValidationError(theMessage.toString(), index);
                continue;
            }
            try {
                this.validateInputValue(inputValue, inputField.getFieldDefinition());
            }
            catch (VWException e) {
                VWString theMessage = new VWString("sim.api.VWScenarioFieldAssignments.FieldAssignmentsRow", "Field Assignments Row: {0}", String.valueOf(index));
                this.m_parent.addValidationError(theMessage.toString() + ", " + e.getLocalizedMessage(), index);
            }
        }
        Iterator i = this.getOutputs().iterator();
        while (i.hasNext()) {
            ((VWScenarioOutputField)i.next()).validate(this.m_parent, index);
        }
    }
}

